import { useState, useEffect } from 'react'
import { motion, AnimatePresence } from 'framer-motion'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  const images = [
    '/images/equipment-1.jpg',
    '/images/equipment-2.jpg',
    '/images/equipment-3.jpg',
    '/images/equipment-4.jpg'
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container-lux">
      <div className="slider-wrapper-lux">
        <AnimatePresence mode="wait">
          <motion.div
            key={currentIndex}
            className="slide-lux"
            initial={{ opacity: 0 }}
            animate={{ opacity: 1 }}
            exit={{ opacity: 0 }}
            transition={{ duration: 0.5 }}
            style={{
              backgroundImage: `url(${images[currentIndex]})`
            }}
          >
            <div className="slide-overlay-lux"></div>
          </motion.div>
        </AnimatePresence>

        <button className="slider-btn-lux slider-btn-prev-lux" onClick={goToPrevious}>
          <ChevronLeft size={20} strokeWidth={2} />
        </button>
        <button className="slider-btn-lux slider-btn-next-lux" onClick={goToNext}>
          <ChevronRight size={20} strokeWidth={2} />
        </button>

        <div className="slider-dots-lux">
          {images.map((_, index) => (
            <button
              key={index}
              className={`dot-lux ${index === currentIndex ? 'active' : ''}`}
              onClick={() => goToSlide(index)}
            />
          ))}
        </div>
      </div>
    </div>
  )
}

export default ImageSlider

